//
//  MCReplicaClient+Access.h
//  MCClientServer
//
//  Created by Brent Gulanowski on 10-02-24.
//  Copyright 2010 Marketcircle Inc. All rights reserved.
//


#import <MCClientServer/MCReplicaClient.h>

#import <MCClientServer/MCClientServerDefines.h>
#import <MCClientServer/MCMirrorSyncDaemon.h>


extern int hasValidOfflineLicenseForProductCode(NSString *productCode,MCPDatabaseConnection *remoteConn, MCSROfflineStatus status, NSDate *expiry, NSString *userName, NSString *databaseName);

@interface MCReplicaClient (Access)
- (void)authenticate;
@end

// This is implemented in MCMirrorSyncDaemon.m
@interface MCMirrorSyncDaemon (MCReplicaAccessDelegate)
- (void)mcReplicaClientAuthenticationSucceeded:(MCReplicaClient *)client;
- (void)mcReplicaClient:(MCReplicaClient *)client gotAuthenticationError:(MCSAuthorizationResultCode)resultCode;
@end

// This must be implemented by subclasses
@interface MCMirrorSyncDaemon (MCReplicaLicenseVerification)
- (BOOL)mcVerifyLicensesForReplicaClient:(MCReplicaClient *)client userOffline:(BOOL)userOnline;
@end
